using System;
using System.Data;
using BLOODTESTTYPE = gov.va.med.vbecs.Common.VbecsTables.BloodTestType;
//
namespace gov.va.med.vbecs.BOL
{
   	#region Header
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/4/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>This object represents a BloodTestType.</summary>
   	#endregion

    public class BloodTestType
    {
		#region Variables

        DataTable _bloodTestTypeDataTable;
        DataRow _bloodTestTypeDataRow;

		#endregion

		#region Constructors
        
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5074"> 
		///		<ExpectedInput>Int</ExpectedInput>
		///		<ExpectedOutput>BloodTestType Object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5075"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
        /// Constructor by blood test type id
        /// </summary>
        /// <param name="bloodTestTypeID"></param>
        public BloodTestType(int  bloodTestTypeID)
        {
            GetBloodTestTypeData(bloodTestTypeID);
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5076"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>BloodTestType Object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5077"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor by DataRow
		/// </summary>
        public BloodTestType(DataRow dataRow)
        {
            this.LoadFromDataRow(dataRow);
        }

		#endregion

		#region Methods
        
		/// <summary>
        /// LoadFromDataRow
        /// </summary>
        /// <param name="dataRow">Data row</param>
        protected void LoadFromDataRow(DataRow dataRow)
        {
            _bloodTestTypeDataTable = dataRow.Table;
            _bloodTestTypeDataRow = dataRow;
        }

        private void GetBloodTestTypeData(int bloodTestTypeID)
        {
            _bloodTestTypeDataTable = DAL.BloodTestType.GetBloodTestType(bloodTestTypeID);
            if (_bloodTestTypeDataTable.Rows.Count > 0) 
            {
                _bloodTestTypeDataRow = _bloodTestTypeDataTable.Rows[0];
            }
        }

		///<Developers>
		///	<Developer>Krzys Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5078"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>BloodTestType object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5079"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets Blood Test Type by BloodTestTypeId
		/// </summary>
		/// <param name="bloodTestTypeID"></param>
		/// <returns></returns>
		public static BloodTestType GetBloodTestType(int  bloodTestTypeID)
		{
			return new BloodTestType(bloodTestTypeID);
		}

		///<Developers>
		///	<Developer>Unknown</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5080"> 
		///		<ExpectedInput>OrderableTestId</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5081"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Hashtable of product modifications
		/// </summary>
		/// <param name="orderableTestId"></param>
		/// <returns></returns>
		public static DataTable GetBloodTestTypes(string orderableTestId)
		{
			return DAL.BloodTestType.GetBloodTestTypes(orderableTestId);
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Unknown</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5082"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5083"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Blood Test Type ID
        /// </summary>
        public int BloodTestTypeId
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.BloodTestTypeId))
                {
                    return 0;
                }
                return (int)_bloodTestTypeDataRow[BLOODTESTTYPE.BloodTestTypeId];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5084"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5085"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Blood Test Name
        /// </summary>
        public string BloodTestName
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.BloodTestName))
                {
                    return "";
                }
                return (string)_bloodTestTypeDataRow[BLOODTESTTYPE.BloodTestName];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5086"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5087"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Orderable Test ID
        /// </summary>
        public int OrderableTestId
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.OrderableTestId))
                {
                    return 0;
                }
                return (int)_bloodTestTypeDataRow[BLOODTESTTYPE.OrderableTestId];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5088"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>short</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5089"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Sort Column
        /// </summary>	
        public short SortColumn
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.SortColumn))
                {
                    return 0;
                }
                return (short)_bloodTestTypeDataRow[BLOODTESTTYPE.SortColumn];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5090"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5091"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
        /// LastUpdateDate
        /// </summary>
        public DateTime LastUpdateDate
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.LastUpdateDate))
                {
                    return System.DateTime.MinValue;
                }
                return (DateTime)_bloodTestTypeDataRow[BLOODTESTTYPE.LastUpdateDate];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5092"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5093"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// LastUpdateUser
        /// </summary>	
        public string LastUpdateUser
        {
			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.LastUpdateUser))
                {
                    return "";
                }
                return (string)_bloodTestTypeDataRow[BLOODTESTTYPE.LastUpdateUser];
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5094"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>byte[]</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5095"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// RowVersion
        /// </summary>
        public byte[] RowVersion
        {			
            get 
            {
                if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.RowVersion))
                {
                    return null;
                }
                return (byte[])_bloodTestTypeDataRow[BLOODTESTTYPE.RowVersion];
            }
        }
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5096"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5097"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Tested With
		/// </summary>
		public string TestedWith
		{
			get
			{
				if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.TestedWith))
				{
					return "";
				}
				return (string)_bloodTestTypeDataRow[BLOODTESTTYPE.TestedWith];
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5098"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5099"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Phase
		/// </summary>
		public string Phase
		{
			get
			{
				if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.Phase))
				{
					return "";
				}
				return (string)_bloodTestTypeDataRow[BLOODTESTTYPE.Phase];

			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5100"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5101"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ReportableTestId
		/// </summary>
		public int ReportableTestId
		{			
			get 
			{
				if (_bloodTestTypeDataRow.IsNull(BLOODTESTTYPE.ReportableTestId))
				{
					return 0;
				}
				return (int)_bloodTestTypeDataRow[BLOODTESTTYPE.ReportableTestId];
			}
		}

		#endregion
    }
}
